set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      NULL,
      15,
      73.456943,
      '3134043',
      195,
      NULL,
      2,
      3,
      NULL,
      4.912736,
      '11- 9-1984',
      45.694236,
      NULL,
      1.277509,
      NULL,
      1,
      0,
      0.567944,
      1.472502,
      0.123761,
      1,
      1,
      1,
      2.991232,
      0.901917,
      3,
      NULL,
      1,
      NULL,
      0,
      0.170210,
      2,
      NULL,
      0.129998,
      NULL,
      1.823718,
      1,
      3,
      0,
      NULL,
      2.245406,
      0,
      0.939197,
      NULL,
      NULL,
      1.648324,
      NULL,
      NULL,
      2.437247,
      0.785699,
      2.566122,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.178541,
      0.541251,
      2.356979,
      1,
      1,
      NULL,
      0.421946,
      0,
      0,
      NULL,
      NULL,
      2,
      4,
      0,
      0,
      1,
      0.111663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370856,
      NULL,
      0.099058,
      0,
      NULL,
      0.929168,
      0,
      1,
      1,
      1.034894,
      0,
      3.888462,
      1.512220,
      NULL,
      0.097084,
      1,
      0.820355,
      0.271529,
      1.509902,
      NULL,
      1.402895,
      7.253394,
      0,
      1,
      0.050987,
      NULL,
      4,
      0.392224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.820229,
      5.558430,
      6,
      NULL,
      NULL,
      7.807572,
      NULL,
      2,
      NULL,
      4.993827,
      4,
      2,
      4.729765,
      NULL,
      1.488511,
      0,
      0.472328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917425,
      NULL,
      0,
      0,
      0.515260,
      1,
      0.490387,
      1.823256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.114877,
      1,
      NULL,
      NULL,
      NULL,
      0.589678,
      1.128427,
      8.961941,
      4.815585,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.146655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060718,
      3.888664,
      3.652842,
      2.890737,
      0.718783,
      2,
      3,
      1.770742,
      1.316872,
      1.643023,
      NULL,
      1.651961,
      0,
      1,
      1.300167,
      0.187582,
      NULL,
      1.257897,
      0.311881,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '40034',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.230938,
      '4021',
      NULL,
      '',
      5.859014,
      3.710727,
      2,
      2,
      1.510324,
      1.585489,
      3,
      1.269309,
      0);
commit;
end;
/


