set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '01302010',
      NULL,
      46,
      '3133011',
      50.376324,
      1,
      3.374683,
      NULL,
      '010301',
      0,
      ' 3-12-1988',
      57,
      56,
      0,
      NULL,
      0.464835,
      NULL,
      1.515236,
      1,
      1,
      0.076631,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.410789,
      3.938454,
      NULL,
      1.886313,
      6,
      2.670268,
      NULL,
      0,
      4.042305,
      4.219456,
      1,
      1,
      5.944286,
      2.875368,
      NULL,
      0,
      NULL,
      NULL,
      1.177816,
      NULL,
      NULL,
      5,
      2,
      5,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      1.641315,
      1.358084,
      1,
      NULL,
      NULL,
      1,
      3.960765,
      0.924629,
      0.511300,
      3,
      3.736213,
      3.670268,
      2.999810,
      1,
      2,
      0.411947,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0.508221,
      1.057141,
      0.098154,
      1,
      1.027518,
      NULL,
      4,
      0,
      2.845011,
      0,
      1.583351,
      0.240626,
      1,
      1.640680,
      NULL,
      0,
      NULL,
      1.669660,
      NULL,
      NULL,
      0,
      4.388683,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      4,
      NULL,
      4.238360,
      0,
      NULL,
      2,
      2.187928,
      4,
      0,
      6.522214,
      0,
      3.205140,
      1,
      NULL,
      4.235373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223522,
      1.401728,
      2,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.480201,
      NULL,
      NULL,
      NULL,
      0.844666,
      0.263287,
      7,
      2,
      1.173779,
      0,
      0.320629,
      NULL,
      NULL,
      NULL,
      NULL,
      7.617602,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.472964,
      0.231218,
      1.926766,
      3.916810,
      2.388688,
      3.380537,
      1.712079,
      1.658236,
      1,
      1.383396,
      2,
      0,
      1.006801,
      1.266581,
      0,
      1,
      0.308386,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02111',
      '',
      '',
      1,
      '',
      '',
      '',
      3.675705,
      NULL,
      '',
      NULL,
      4,
      2,
      0,
      3,
      2,
      3,
      1,
      NULL,
      0.611125);
commit;
end;
/


