set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4133',
      '21223320',
      73,
      NULL,
      '1303214',
      NULL,
      3,
      2.286218,
      NULL,
      '220014',
      0.968065,
      '11- 6-1978',
      NULL,
      22.669318,
      0,
      NULL,
      6,
      0.437759,
      NULL,
      0.579809,
      NULL,
      NULL,
      0,
      0,
      2.864159,
      1,
      0.008745,
      0.607008,
      0,
      4,
      0.983723,
      0,
      NULL,
      1.103551,
      5.887848,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0.370034,
      NULL,
      NULL,
      0.003878,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.438402,
      0,
      3,
      1.666786,
      1.868265,
      0.341486,
      0.114299,
      0.165247,
      1.904932,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.513932,
      1,
      1.343250,
      NULL,
      NULL,
      0.905285,
      NULL,
      NULL,
      NULL,
      1.517109,
      1.000417,
      1,
      0.842689,
      0.299729,
      NULL,
      1.064244,
      1,
      NULL,
      NULL,
      3.793217,
      1.355364,
      1,
      0,
      0.760470,
      6,
      0.644326,
      NULL,
      1,
      NULL,
      1,
      1.973083,
      NULL,
      NULL,
      1,
      0.673969,
      4,
      NULL,
      2.295959,
      1.144677,
      10,
      2,
      10,
      9.377851,
      1,
      5.091862,
      NULL,
      1.122091,
      0.589816,
      0.007610,
      NULL,
      1.584351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.926350,
      1,
      1,
      0.193709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129437,
      1.170746,
      5,
      2,
      NULL,
      0,
      0.216296,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.320627,
      2,
      3,
      0,
      NULL,
      0.582939,
      2.397175,
      1.604519,
      2,
      NULL,
      0,
      0,
      1,
      1.307664,
      0,
      1,
      0,
      1.622856,
      1.796117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      1.305131,
      NULL,
      '',
      '',
      0.346676,
      '2243',
      '',
      '',
      NULL,
      2,
      0.439572,
      NULL,
      0.362796,
      0,
      1,
      NULL,
      3);
commit;
end;
/


