set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1041',
      NULL,
      NULL,
      3.049354,
      '3113131',
      86,
      NULL,
      0.729210,
      NULL,
      '311024',
      4.701880,
      NULL,
      39,
      6.814409,
      0,
      NULL,
      1.200612,
      1,
      1,
      NULL,
      0,
      1.756331,
      0.611505,
      0.471188,
      0,
      0,
      2.599614,
      1,
      1.590097,
      3,
      NULL,
      0.082283,
      5.940152,
      2.203340,
      NULL,
      NULL,
      2.467329,
      0.062270,
      2.318386,
      NULL,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.606718,
      0,
      0,
      1,
      0,
      1.025045,
      NULL,
      NULL,
      3.436301,
      1,
      2.717784,
      NULL,
      1,
      2.007963,
      NULL,
      NULL,
      0.142324,
      1,
      1,
      1.011495,
      2,
      5,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.492395,
      0,
      1.839967,
      1,
      0.950756,
      1,
      NULL,
      1,
      0.633872,
      NULL,
      NULL,
      0.234689,
      0.288591,
      NULL,
      NULL,
      0.975054,
      NULL,
      NULL,
      NULL,
      0.308747,
      0.939760,
      0,
      3.694250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001488,
      0,
      1.382419,
      0.635095,
      6,
      0.041942,
      4.376659,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.960062,
      5,
      NULL,
      0.477538,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      1,
      1.868970,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.935663,
      2.198662,
      1.805714,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.310087,
      NULL,
      2.573820,
      NULL,
      NULL,
      NULL,
      0.082297,
      NULL,
      1.862123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.701036,
      2.101872,
      1.528110,
      0.514465,
      1,
      1.152356,
      0.544225,
      1,
      1.394458,
      0.899871,
      1,
      1,
      1.940245,
      0.211627,
      1,
      0.286376,
      0.596535,
      0.026439,
      1.536027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0.856138,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      4.795658,
      NULL,
      NULL,
      1,
      0,
      3.984100);
commit;
end;
/


