set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3010',
      '11430210',
      NULL,
      NULL,
      '3402312',
      303.283568,
      4,
      NULL,
      3,
      '330324',
      4.832187,
      NULL,
      1.284163,
      29,
      0,
      NULL,
      1.364306,
      1.520721,
      3,
      1,
      0,
      0,
      1.611935,
      1.067653,
      0.620692,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920356,
      0,
      1,
      NULL,
      NULL,
      2.699491,
      4.944960,
      1,
      5,
      0,
      0.107281,
      3,
      3,
      1.040372,
      NULL,
      NULL,
      1.573425,
      NULL,
      NULL,
      6.973534,
      5.060258,
      1,
      3.855114,
      3.147456,
      1,
      0.883393,
      1,
      1,
      NULL,
      0.862510,
      0.098356,
      2,
      NULL,
      1.707645,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1.869670,
      1.786819,
      1,
      NULL,
      0.710315,
      0.514988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318195,
      NULL,
      1.637751,
      1,
      1,
      NULL,
      1,
      0.466506,
      1,
      0,
      0.284064,
      1,
      1.688526,
      0,
      1.102385,
      0.761056,
      0.248211,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.546252,
      0,
      0,
      0.235503,
      2,
      0.869420,
      NULL,
      NULL,
      NULL,
      NULL,
      4.004655,
      0.594254,
      4,
      1.321963,
      NULL,
      1,
      1.219500,
      NULL,
      8,
      NULL,
      0,
      7,
      2.903518,
      5.605331,
      0.245808,
      7.324831,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649851,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.671035,
      1,
      0,
      0.260182,
      0,
      1,
      3,
      2.326173,
      1,
      NULL,
      NULL,
      NULL,
      2.127699,
      NULL,
      6.993676,
      5.334999,
      NULL,
      2,
      1.720554,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309221,
      1.889393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.543490,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.159565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      '',
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      0,
      0.408407,
      1,
      NULL);
commit;
end;
/


