set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3341',
      NULL,
      23.014357,
      94,
      '4111421',
      81.158841,
      0,
      1,
      3,
      '423313',
      3,
      '10- 2-1998',
      8,
      58,
      1,
      NULL,
      0.517111,
      0,
      3,
      1,
      0,
      1,
      0.657991,
      0.944569,
      1,
      1,
      5.563322,
      1.972588,
      NULL,
      1,
      1.047807,
      1,
      0,
      2.223089,
      NULL,
      3.169363,
      5,
      NULL,
      4,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418156,
      4,
      NULL,
      0,
      3,
      2,
      NULL,
      1.625463,
      1.387164,
      2,
      0,
      0.722650,
      2,
      NULL,
      1,
      2,
      3,
      0,
      1,
      0,
      1.060315,
      3.681043,
      NULL,
      0,
      0,
      1.329159,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.706798,
      0,
      NULL,
      NULL,
      1.529941,
      0.147696,
      0.633164,
      1,
      1.972443,
      0.592216,
      0,
      0.365482,
      0,
      0,
      NULL,
      1.375143,
      0.214828,
      0.559491,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.115363,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.196716,
      2.631582,
      1,
      0,
      4,
      2,
      NULL,
      1,
      0.802943,
      5.434133,
      4.337187,
      3,
      NULL,
      7,
      5.931320,
      NULL,
      1.304905,
      1.337717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493332,
      2,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828556,
      1.834709,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.551783,
      9,
      0.359393,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.085958,
      0.951415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.537147,
      0.168394,
      3.809885,
      2.431979,
      NULL,
      1,
      2,
      3.618739,
      1,
      1.007155,
      3.018889,
      0,
      0,
      0,
      NULL,
      1,
      1.869686,
      0,
      1.124470,
      0.714940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.443358,
      '33132',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.833273,
      '4023',
      NULL,
      NULL,
      5.096500,
      0,
      1.531330,
      1,
      3,
      3.665091,
      1,
      3,
      1.690496);
commit;
end;
/


