set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '1301322',
      13,
      2,
      NULL,
      NULL,
      NULL,
      2.462791,
      ' 8-22-1998',
      29.609984,
      NULL,
      0.883617,
      NULL,
      6.885387,
      0.953671,
      2,
      0.382406,
      1.490284,
      1,
      0.927330,
      0,
      0,
      NULL,
      NULL,
      0.409231,
      NULL,
      0,
      3,
      1.634034,
      2.374171,
      1,
      NULL,
      1.565539,
      0.295100,
      NULL,
      4,
      1,
      NULL,
      1.885455,
      1,
      1.016736,
      NULL,
      NULL,
      1.910946,
      NULL,
      NULL,
      1,
      0.571327,
      1,
      1.975651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121167,
      1,
      NULL,
      1.338771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.684239,
      1.847861,
      1.519127,
      0.376577,
      0.189471,
      0.413617,
      0.170139,
      1,
      0.772075,
      0,
      NULL,
      NULL,
      1.171309,
      NULL,
      1.203553,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.226187,
      0.179905,
      1.995605,
      4.058725,
      1.201492,
      NULL,
      1,
      1.424488,
      NULL,
      4,
      NULL,
      NULL,
      1.669538,
      0.031963,
      3.734821,
      NULL,
      4.803037,
      7.678059,
      0.837858,
      NULL,
      NULL,
      4,
      1.343158,
      NULL,
      0.978693,
      1.789819,
      NULL,
      NULL,
      7.032518,
      1.863268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.195784,
      0,
      1,
      1.399526,
      1.338208,
      0.162256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1.294555,
      NULL,
      NULL,
      NULL,
      1.307058,
      1.893106,
      NULL,
      1.508303,
      2.489081,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.050769,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      3.863102,
      0,
      3.790260,
      2.473910,
      0,
      0.032271,
      1.864485,
      NULL,
      1.843789,
      0.104741,
      0.125607,
      NULL,
      1.898195,
      NULL,
      0.187933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.650564,
      '41021',
      NULL,
      NULL,
      0.748765,
      '',
      '',
      NULL,
      1.608301,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


