set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      NULL,
      33,
      NULL,
      '1144434',
      86.119884,
      1,
      2.064448,
      0,
      '300331',
      2.839655,
      NULL,
      21,
      31.306927,
      NULL,
      NULL,
      1.889070,
      0,
      2,
      NULL,
      1,
      NULL,
      0.901329,
      3.609787,
      0,
      0,
      1.902574,
      0.787627,
      0.457959,
      0,
      4.015904,
      1.908676,
      3.525971,
      1.195481,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      0.727315,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.382148,
      0.324006,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565671,
      NULL,
      1,
      1.106824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061051,
      1.249277,
      NULL,
      0,
      0.029464,
      4.385802,
      0.078974,
      1.867341,
      1,
      0.374039,
      1,
      1,
      0,
      0.228511,
      1,
      0,
      1,
      NULL,
      NULL,
      0.061494,
      0,
      2,
      1.569534,
      NULL,
      1.869348,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.380816,
      0,
      NULL,
      4,
      2.494444,
      4.480214,
      NULL,
      NULL,
      10.695830,
      9.882499,
      10.821379,
      NULL,
      NULL,
      0,
      0.658643,
      0.889489,
      NULL,
      NULL,
      0,
      0.104401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.577514,
      0,
      0,
      0,
      0.603933,
      1.636767,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565659,
      NULL,
      9,
      3.720654,
      0.470233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.474419,
      0,
      0.437966,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941109,
      1,
      0.818156,
      5,
      0,
      5.807808,
      0,
      NULL,
      NULL,
      NULL,
      0.716549,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.912102,
      3.517027,
      1,
      0,
      3,
      0.282752,
      2.687177,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.761911,
      0.572611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076580,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.502220,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


