set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '44414214',
      NULL,
      11,
      '4020413',
      110.144256,
      4,
      3,
      2,
      '342431',
      1.747518,
      '10-26-1989',
      12.472719,
      51.671418,
      0,
      NULL,
      1.935330,
      0.138253,
      0,
      0.890301,
      0.870176,
      0.797454,
      NULL,
      NULL,
      1.942115,
      NULL,
      NULL,
      0.112717,
      7,
      1,
      NULL,
      1,
      5.735981,
      0,
      NULL,
      0,
      0.727249,
      0,
      NULL,
      0,
      1.787394,
      1.186865,
      3.685787,
      0.236194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.773941,
      NULL,
      1,
      1.311669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.568785,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.873289,
      2,
      NULL,
      6.432235,
      0,
      1.070487,
      1,
      1.330516,
      0.630656,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.751311,
      0.609992,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.463095,
      0.963226,
      2.267939,
      0,
      NULL,
      3,
      0.978599,
      1.063757,
      0,
      3.317140,
      2,
      2.006664,
      1,
      NULL,
      0.000819,
      8.870369,
      NULL,
      NULL,
      4,
      7.421834,
      NULL,
      2.691811,
      NULL,
      NULL,
      2.152691,
      5.678865,
      1,
      6,
      0.360561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.702540,
      0.313941,
      1,
      0.201040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.986158,
      NULL,
      0.480440,
      0,
      3.865178,
      2.639926,
      1.690612,
      0,
      NULL,
      3.981773,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1,
      7.491068,
      0,
      2.695208,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.032394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529596,
      1,
      0,
      2.164809,
      1,
      NULL,
      2,
      1,
      0,
      2.266110,
      0.853261,
      NULL,
      1,
      1.360549,
      NULL,
      0.843533,
      1.648861,
      1,
      1.151564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.533243,
      '11423',
      NULL,
      '',
      1.972308,
      NULL,
      '',
      '',
      1.476939,
      '',
      '',
      NULL,
      3.781830,
      0,
      NULL,
      3,
      3,
      7,
      NULL,
      3.600595,
      1);
commit;
end;
/


