set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      NULL,
      NULL,
      NULL,
      '2133443',
      49.843283,
      NULL,
      2,
      3,
      NULL,
      1,
      ' 5- 9-1982',
      2.757295,
      NULL,
      0,
      NULL,
      NULL,
      0.458456,
      1,
      NULL,
      0.927779,
      2.531200,
      NULL,
      NULL,
      1.535321,
      0,
      3.158394,
      NULL,
      1.814767,
      5,
      3,
      0.471729,
      0.980898,
      0,
      1,
      2,
      NULL,
      0,
      6.008735,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.951183,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.587797,
      3.548049,
      1.826122,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.033021,
      0,
      2.799679,
      3,
      1.008848,
      1.774754,
      0.939179,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.584635,
      0.393662,
      1.321920,
      NULL,
      0,
      1.968720,
      3,
      0.275358,
      3.559899,
      NULL,
      5,
      1,
      1.208610,
      2,
      NULL,
      1.873646,
      3.524040,
      NULL,
      2,
      3,
      5,
      6.324379,
      2,
      4,
      NULL,
      4,
      NULL,
      8,
      8.587884,
      2,
      NULL,
      2.421346,
      1.957389,
      1,
      1,
      NULL,
      0.835016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.932283,
      0.587307,
      1.619813,
      0.537079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.771610,
      NULL,
      8.513706,
      NULL,
      0.715538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.226321,
      2.343822,
      2,
      1,
      3.343749,
      NULL,
      NULL,
      NULL,
      0.341404,
      5.108893,
      0.572409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563080,
      3,
      0,
      1.063809,
      1.287743,
      0.254439,
      0,
      0.631432,
      2,
      3,
      0.403103,
      1.175786,
      0.793900,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.992006,
      '23233',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.478507,
      '',
      NULL,
      '',
      4,
      NULL,
      2,
      NULL,
      4.795874,
      0.889558,
      2.902253,
      2,
      NULL);
commit;
end;
/


