set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      '343313',
      2,
      '10- 6-1990',
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.631163,
      0.274256,
      NULL,
      1.909654,
      1.405577,
      1,
      2.445722,
      1.517130,
      0,
      3.283850,
      3.960148,
      1.835444,
      1.318822,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      0.552217,
      0.201456,
      2,
      0.703892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.850172,
      0,
      0,
      1.430369,
      NULL,
      0.562127,
      NULL,
      1.931251,
      1,
      NULL,
      NULL,
      NULL,
      2.343809,
      1.642032,
      1.367399,
      NULL,
      0.330103,
      1.463078,
      NULL,
      0,
      NULL,
      1,
      1.554577,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.009981,
      4,
      0,
      1,
      0,
      0.414957,
      0,
      1.346945,
      0.865915,
      NULL,
      1,
      0.697825,
      0.471414,
      NULL,
      NULL,
      1.707511,
      NULL,
      1.241000,
      4,
      1,
      NULL,
      1.692208,
      1,
      5,
      1.717546,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.232886,
      1.983509,
      2.731818,
      8.975746,
      NULL,
      0,
      6.769768,
      2,
      0,
      4.717317,
      NULL,
      NULL,
      8,
      NULL,
      0.548434,
      0.967629,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572681,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      0.427347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.881933,
      NULL,
      1,
      2.187271,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1.943331,
      0.786912,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.683727,
      NULL,
      NULL,
      NULL,
      7,
      1.659645,
      NULL,
      NULL,
      1.174986,
      2.719027,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.812508,
      NULL,
      0,
      2,
      NULL,
      2,
      1,
      3,
      2,
      0.494172,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.894359,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


