set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '2133020',
      23,
      3,
      2,
      2,
      '002102',
      3,
      ' 3- 0-1994',
      2.549711,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.342417,
      NULL,
      NULL,
      1.108415,
      0,
      1,
      3.700061,
      1.453274,
      6,
      1.253895,
      1.286278,
      1,
      2.193675,
      0,
      4.017849,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.609439,
      2,
      0.730346,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.056464,
      1.812730,
      3,
      1,
      0.418045,
      1,
      1.691779,
      1,
      2,
      0,
      1.052183,
      1.243252,
      3.725574,
      NULL,
      0.436394,
      3,
      0.461626,
      NULL,
      0.961464,
      5.696045,
      5.310990,
      6.805682,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      4,
      1.517643,
      NULL,
      1,
      1.485043,
      1.126715,
      1,
      NULL,
      1.912496,
      NULL,
      0,
      1.077542,
      0.681267,
      NULL,
      1,
      NULL,
      0.443789,
      7.411201,
      5.473888,
      0.743647,
      0.389172,
      1.872727,
      7.696401,
      3.655116,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384347,
      0.820964,
      4,
      0,
      6,
      NULL,
      10.706922,
      4,
      6,
      0.152034,
      4.267160,
      7.413631,
      9.405262,
      NULL,
      5,
      6.681092,
      NULL,
      1.821273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.629730,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.747502,
      NULL,
      3.783963,
      NULL,
      NULL,
      0,
      2.816117,
      0,
      0.223601,
      0.601794,
      NULL,
      7.985691,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.574582,
      5.587001,
      6.538235,
      3,
      2,
      3.900494,
      1.422625,
      NULL,
      NULL,
      0.790089,
      NULL,
      0.028087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      1.409945,
      0.393985,
      0.432765,
      0,
      1,
      2.777436,
      1,
      0,
      1,
      0,
      1.386580,
      1.643750,
      0.024864,
      0,
      0.437067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.962960,
      '31110',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.165032,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


