set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '0200021',
      60,
      3,
      3.134453,
      1,
      NULL,
      NULL,
      NULL,
      41.445485,
      NULL,
      1.570737,
      NULL,
      0.871943,
      1,
      2.975856,
      1.146664,
      0.405628,
      NULL,
      1,
      NULL,
      0.982421,
      0,
      5.932592,
      0,
      0,
      NULL,
      1.688329,
      NULL,
      1.526107,
      0,
      1,
      0.405160,
      NULL,
      1.248974,
      5,
      1,
      3.860702,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.285267,
      NULL,
      NULL,
      9.496817,
      NULL,
      0.252316,
      0.404204,
      NULL,
      0.733382,
      3,
      3,
      NULL,
      NULL,
      1.402624,
      3.406123,
      1.453915,
      0,
      1,
      1.884437,
      3.525128,
      0.807674,
      1.002052,
      0.810897,
      NULL,
      0.650026,
      7.273723,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1.529753,
      0,
      2.638517,
      1,
      1.572039,
      1.619202,
      1.603213,
      0.657072,
      NULL,
      0.636532,
      0,
      NULL,
      1.439333,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.020111,
      1,
      1,
      1.252907,
      1.108492,
      2.747788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032422,
      0.706707,
      5.969506,
      1.725928,
      3.007301,
      7,
      3,
      4.262639,
      2.395104,
      0,
      4.247440,
      9,
      8.443160,
      4,
      2.176719,
      3.714613,
      NULL,
      1,
      1.904513,
      0.871378,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580382,
      0,
      0,
      0,
      0,
      1.732732,
      1,
      1.991799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.102537,
      0,
      NULL,
      NULL,
      NULL,
      0.573363,
      1,
      NULL,
      4,
      0.777148,
      1,
      1.176090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.655288,
      0,
      2,
      0.287236,
      NULL,
      0.376001,
      1.757714,
      1,
      1.802130,
      NULL,
      1,
      NULL,
      NULL,
      0.789141,
      NULL,
      1.732901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.635776,
      NULL,
      1.919433,
      1.295100,
      0,
      0,
      0,
      '21322',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


