set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '1143040',
      12,
      4,
      NULL,
      3,
      '103420',
      3.025580,
      ' 0-27-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      1,
      0.055704,
      NULL,
      0.067110,
      0,
      2.347451,
      NULL,
      0,
      2,
      1,
      NULL,
      5,
      1.672117,
      0.377353,
      NULL,
      2,
      3.250921,
      5.072721,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0.970556,
      NULL,
      NULL,
      2.483273,
      1,
      5.240430,
      2.560878,
      1,
      0,
      2.903761,
      NULL,
      1.881416,
      0.037301,
      NULL,
      0,
      1,
      1.060166,
      1,
      1,
      1.380591,
      1,
      1.871375,
      1.441470,
      1,
      0,
      7.487269,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301406,
      0,
      7,
      0,
      NULL,
      1.852419,
      0,
      1,
      1.254266,
      0,
      1,
      0.380075,
      1.620489,
      0.454078,
      1,
      1.588053,
      NULL,
      NULL,
      NULL,
      4.469984,
      2,
      0.546636,
      0.468721,
      NULL,
      3,
      0.872494,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826668,
      1.836650,
      5,
      1.341204,
      2,
      4.203288,
      5.974784,
      8.215651,
      6,
      2,
      NULL,
      2,
      4.180132,
      1.906972,
      7.006040,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.283216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.568168,
      NULL,
      NULL,
      NULL,
      5.384528,
      2.019424,
      3.362267,
      8.101537,
      0.893096,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.907970,
      2.051124,
      0.106455,
      2.861693,
      3.168010,
      0,
      2,
      NULL,
      NULL,
      0.659783,
      0.373268,
      NULL,
      1.231655,
      0.695429,
      0,
      1.290779,
      0.229582,
      0.475229,
      1.958461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394742,
      0.033201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540914,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012715,
      NULL,
      NULL,
      NULL,
      NULL,
      3.508239,
      0.661982,
      0.712879,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      '43113',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


