set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '3401243',
      87,
      6,
      2.506679,
      1,
      '034311',
      3,
      NULL,
      51,
      NULL,
      0.835773,
      NULL,
      1.638147,
      0,
      0,
      1.727374,
      1.263510,
      1.903160,
      1,
      0,
      3,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1.563358,
      NULL,
      NULL,
      5.078856,
      7.442315,
      1.584186,
      5,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.051380,
      NULL,
      NULL,
      0.963077,
      4,
      4,
      1.636361,
      1.221194,
      0,
      0.638763,
      3,
      2,
      1.003251,
      1.354609,
      2,
      2.731075,
      NULL,
      NULL,
      0,
      1,
      2.077606,
      NULL,
      2.670970,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.619002,
      0,
      NULL,
      NULL,
      0.908020,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.698235,
      1,
      0,
      0,
      0,
      0.229986,
      NULL,
      1.849438,
      0,
      1.101786,
      1,
      0,
      0.613955,
      NULL,
      0,
      1.768425,
      0.506108,
      0.176820,
      0,
      1.110293,
      NULL,
      1.455129,
      4,
      1.166892,
      1,
      3.822105,
      1,
      0.593583,
      4.794962,
      0,
      1,
      4,
      7,
      9,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.239874,
      NULL,
      NULL,
      1,
      1,
      1,
      1.820564,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010234,
      1.326111,
      0,
      0,
      0.992836,
      1.929081,
      1.725352,
      0.382896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      1,
      0,
      5.383652,
      0,
      NULL,
      NULL,
      0,
      7.705233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.256638,
      1,
      NULL,
      1,
      0,
      1.502944,
      1,
      1.333945,
      3,
      NULL,
      1.983207,
      1.665731,
      1.146027,
      0.434829,
      1.215074,
      1,
      0.130644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252983,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073364,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0.935932,
      0.390727,
      0,
      1.008509,
      '40112',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.298275,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


