set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      28,
      4,
      2.870603,
      1,
      '322433',
      0,
      ' 4-16-1999',
      54,
      NULL,
      0,
      NULL,
      0,
      0.582281,
      1,
      0,
      1.093777,
      0.868528,
      1.044755,
      0.187247,
      1,
      0,
      1,
      1.226036,
      NULL,
      NULL,
      1.281834,
      1.396643,
      7,
      1.134279,
      1,
      2.987931,
      7,
      1.567620,
      3,
      1,
      0,
      0.690080,
      0.655620,
      1,
      NULL,
      NULL,
      1.475604,
      NULL,
      NULL,
      8.964525,
      0.627339,
      2.770261,
      NULL,
      1,
      0,
      NULL,
      3.648382,
      1.022083,
      1.744420,
      0.777615,
      2.473876,
      2.738825,
      2,
      2,
      NULL,
      NULL,
      2.762170,
      2.326979,
      NULL,
      1.671161,
      1.365039,
      1.740925,
      0,
      2,
      1.315548,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.070300,
      0,
      0,
      0,
      0.669419,
      0,
      1,
      NULL,
      0,
      0.306003,
      0,
      0,
      1.408876,
      0.184075,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1.072729,
      1.418083,
      1.377301,
      1,
      NULL,
      1.910146,
      4.239324,
      1.187796,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643867,
      1,
      3,
      0,
      NULL,
      NULL,
      7.618432,
      0,
      9.802000,
      1,
      5.205056,
      8,
      0.258116,
      5,
      3.235901,
      4.555229,
      3,
      0.401253,
      0.067644,
      4.742860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.951284,
      2,
      2,
      1.402551,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206922,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.940403,
      0.715794,
      0.692064,
      3,
      4,
      NULL,
      NULL,
      0.288695,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      0.936979,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.448514,
      3.456763,
      2.136844,
      0,
      NULL,
      3.660121,
      1,
      1,
      1.382812,
      3,
      NULL,
      0.566983,
      NULL,
      0,
      1,
      NULL,
      1.251600,
      NULL,
      1.646016,
      1.247569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.796204,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440955,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180481,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152069,
      1,
      1.893862,
      NULL,
      0,
      1.732427,
      1,
      1,
      1.872825,
      '20201',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


