set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '3131344',
      84,
      3,
      NULL,
      0,
      '240110',
      3,
      ' 0-14-1981',
      57,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.343801,
      3,
      NULL,
      0.896185,
      0.710058,
      0.191989,
      1,
      0,
      0,
      5.907415,
      NULL,
      1.806892,
      0.994572,
      NULL,
      NULL,
      1.395601,
      NULL,
      NULL,
      NULL,
      NULL,
      3.692922,
      NULL,
      2,
      0.565776,
      3.005877,
      NULL,
      2,
      0,
      2,
      3.336619,
      0.524162,
      3,
      1.643324,
      NULL,
      1.329160,
      2.284224,
      NULL,
      0,
      NULL,
      1,
      0.695949,
      NULL,
      1,
      NULL,
      1.601097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772850,
      0.099894,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.391374,
      0,
      NULL,
      0.676191,
      0.205363,
      NULL,
      2.504390,
      1.212723,
      1.734919,
      0,
      1.953936,
      0.149150,
      NULL,
      0,
      0.894265,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.906472,
      NULL,
      NULL,
      NULL,
      NULL,
      4.031559,
      1.342021,
      2,
      0.909495,
      NULL,
      9.991460,
      4,
      5,
      3.614328,
      NULL,
      5,
      6.822440,
      8,
      3.204846,
      3.516310,
      2.011820,
      3,
      0.118870,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.106610,
      NULL,
      2,
      1.415546,
      1.393965,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.748999,
      1.159905,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.257010,
      3.986082,
      3.236758,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014510,
      0,
      0.392185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.919619,
      2.146976,
      0,
      NULL,
      3,
      0.852030,
      2.449505,
      1.867084,
      0.588765,
      3,
      NULL,
      0.495618,
      0,
      1,
      0.560461,
      1,
      NULL,
      1.546756,
      0.676612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01320',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.501664,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


