set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '3003444',
      84.712750,
      3,
      0.941694,
      NULL,
      '110412',
      3,
      NULL,
      14.524967,
      NULL,
      0.404014,
      NULL,
      0,
      NULL,
      0.533594,
      1,
      NULL,
      0,
      0.002664,
      0,
      NULL,
      1.418797,
      NULL,
      1.990803,
      1,
      0,
      7.857876,
      0,
      9,
      0,
      3.305519,
      NULL,
      0.456282,
      0.697900,
      NULL,
      NULL,
      2,
      NULL,
      0.410791,
      0.650439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      3.433032,
      NULL,
      NULL,
      3,
      1.312342,
      0.537183,
      3.486044,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      3.449971,
      2,
      3,
      NULL,
      1.087405,
      1.709624,
      5.871957,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      5,
      0.666877,
      1,
      NULL,
      0,
      0,
      0.099294,
      0.568147,
      NULL,
      0,
      0,
      0,
      NULL,
      0.467425,
      NULL,
      1.128704,
      3.221907,
      5,
      NULL,
      0.074075,
      0.676902,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556627,
      0.267089,
      1,
      0,
      1,
      3,
      8.159702,
      3,
      NULL,
      1.113311,
      NULL,
      7,
      2,
      7.883848,
      2,
      2,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022149,
      0.423845,
      0,
      1,
      NULL,
      1,
      0.172889,
      0.169499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501718,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.893739,
      NULL,
      4,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320671,
      6.020952,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.204311,
      1.771533,
      2,
      NULL,
      3.285705,
      1,
      0.327158,
      1,
      0.396160,
      0,
      NULL,
      0.313323,
      0,
      0.327448,
      NULL,
      1,
      0.965187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367181,
      1.360383,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      '24102',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


