set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '1041112',
      50,
      4,
      0,
      3,
      '432214',
      1.643742,
      ' 1-23-2002',
      NULL,
      NULL,
      1.211620,
      NULL,
      0,
      1.632722,
      NULL,
      NULL,
      0.613040,
      1.127897,
      1,
      0.317539,
      NULL,
      0.780662,
      2.258735,
      0,
      1.532532,
      0.184588,
      0,
      1.507093,
      3,
      1.596670,
      1,
      2.727559,
      0.402945,
      0.390049,
      NULL,
      0,
      5.529335,
      0,
      NULL,
      0.680496,
      NULL,
      NULL,
      1.215222,
      NULL,
      NULL,
      7.150775,
      NULL,
      0,
      0,
      3,
      1.491825,
      NULL,
      0,
      3,
      0.972915,
      1,
      0.398865,
      3.397081,
      1,
      0,
      NULL,
      NULL,
      0,
      0.965731,
      NULL,
      NULL,
      1.425082,
      3.874732,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      3.080774,
      3,
      0,
      1.522697,
      NULL,
      0.318790,
      1,
      0.155902,
      0,
      1.331801,
      0.178852,
      0.685595,
      NULL,
      1.647284,
      NULL,
      1,
      0.702307,
      3,
      0,
      1.317392,
      0.101428,
      5.251779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      0,
      5,
      2,
      0.311743,
      0.247953,
      9,
      7,
      NULL,
      2.239139,
      8,
      4,
      0,
      5,
      1.994599,
      0,
      1.885155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.693325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842039,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.701895,
      1,
      1.300756,
      NULL,
      NULL,
      NULL,
      3.002089,
      0,
      3,
      3.664023,
      3.205711,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.189075,
      2.499298,
      1.398961,
      NULL,
      1,
      3.538786,
      0.752542,
      0.153443,
      1,
      3,
      1,
      NULL,
      1,
      0.487067,
      1,
      1,
      1.380081,
      1,
      1,
      1.954638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.951828,
      0.616823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      1.417877,
      2,
      0.936288,
      '32021',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


