set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '0343323',
      68.530055,
      0,
      0,
      1,
      NULL,
      3.133587,
      ' 1-23-1982',
      NULL,
      NULL,
      1.893018,
      NULL,
      0.667764,
      NULL,
      1,
      1.443669,
      0.975350,
      NULL,
      NULL,
      0,
      NULL,
      1.134282,
      1,
      1.662188,
      0.284776,
      NULL,
      1.346219,
      1.012762,
      9,
      1.721640,
      0,
      2.502852,
      0,
      1.780547,
      4.847148,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.854851,
      0,
      0.690302,
      1,
      1.080608,
      NULL,
      NULL,
      1,
      0.456915,
      0,
      1,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      1.855363,
      0,
      1,
      1.915270,
      5.189963,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.202354,
      0,
      1,
      1,
      0,
      1.997875,
      0.186083,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      3.689055,
      7.354092,
      NULL,
      1,
      0,
      NULL,
      3.754974,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      4,
      6.870459,
      0.647323,
      NULL,
      1.249395,
      1,
      NULL,
      2,
      2.462540,
      NULL,
      3,
      5,
      0.378107,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      0.489178,
      1,
      0.163765,
      0.070096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.515504,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.195578,
      5.872820,
      1,
      0,
      0.733327,
      NULL,
      NULL,
      NULL,
      0.096324,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493224,
      0.184643,
      1.268067,
      1.123429,
      NULL,
      NULL,
      1,
      2.162268,
      1,
      NULL,
      3.974790,
      1,
      0,
      1.240048,
      0,
      0.326763,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829755,
      NULL,
      NULL,
      NULL,
      NULL,
      3.940558,
      1,
      0,
      NULL,
      1,
      NULL,
      0.533725,
      0,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


