set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '1342002',
      NULL,
      3,
      NULL,
      1,
      '014120',
      NULL,
      NULL,
      29.314637,
      NULL,
      1,
      NULL,
      2.831552,
      2,
      NULL,
      0,
      1.469349,
      2.647124,
      1,
      NULL,
      3,
      0.170981,
      0.929225,
      0,
      NULL,
      1.548982,
      0,
      0.793284,
      4,
      3.128948,
      0.871162,
      0,
      2.452944,
      3.223496,
      NULL,
      0,
      5.439230,
      2.166607,
      2,
      1.672284,
      NULL,
      NULL,
      0.632667,
      NULL,
      NULL,
      NULL,
      2.209265,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.783294,
      2,
      1,
      2,
      NULL,
      0.029835,
      NULL,
      0.379725,
      1.562349,
      1.992196,
      2.546202,
      NULL,
      7,
      1,
      0,
      1.042495,
      1.220600,
      NULL,
      NULL,
      1.920363,
      NULL,
      NULL,
      NULL,
      3.601687,
      5,
      0,
      4.643407,
      1,
      6,
      0.503352,
      3,
      NULL,
      0,
      1,
      1.273085,
      NULL,
      NULL,
      1.141954,
      0.827378,
      0,
      0,
      NULL,
      0,
      4.254158,
      1.011952,
      0,
      4.903733,
      1,
      1.353949,
      0,
      5,
      2.985937,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7.793242,
      0.624952,
      2.094854,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      4,
      11,
      0,
      0,
      0.845331,
      0.701714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.794940,
      1,
      2.716188,
      1.564176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618010,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182895,
      1.935449,
      1.496579,
      1.594560,
      NULL,
      0,
      6,
      1,
      6.803668,
      NULL,
      NULL,
      2,
      0.593634,
      NULL,
      NULL,
      NULL,
      NULL,
      3.664826,
      0.724985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.773922,
      3,
      1.967552,
      2,
      1.546283,
      3,
      3.920190,
      1,
      2,
      NULL,
      1,
      0,
      0,
      0.745301,
      1,
      NULL,
      0.494656,
      0.394547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964910,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457690,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.348834,
      0,
      NULL,
      2.476535,
      1,
      0,
      2,
      2,
      '30321',
      '33033',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


