set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '023',
      '22',
      9.504332,
      NULL,
      '1411224',
      15.429294,
      5,
      0.515494,
      1,
      '232220',
      1.939702,
      ' 2-29-1976',
      38,
      3,
      NULL,
      NULL,
      5.937570,
      1.836374,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.999809,
      2,
      1,
      0.881286,
      NULL,
      0.773195,
      0.056868,
      NULL,
      0,
      1.473771,
      8.206137,
      2,
      0,
      8.003817,
      0,
      4,
      5.714740,
      1.499695,
      1.888933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.187042,
      2.528490,
      1,
      0,
      0.915916,
      3,
      0.580857,
      1,
      2,
      NULL,
      1,
      1.663020,
      0,
      0,
      0,
      2,
      1.453841,
      1.124234,
      NULL,
      1.654701,
      2.921357,
      6.385789,
      0,
      1,
      1.835217,
      0.312030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.195303,
      NULL,
      2.209956,
      2,
      2.489841,
      0.282320,
      3,
      NULL,
      NULL,
      0,
      1.420890,
      6.807531,
      0.094737,
      0.049584,
      1.913583,
      0.759510,
      0.735163,
      NULL,
      1,
      1,
      5.372482,
      NULL,
      0.871823,
      1.280018,
      NULL,
      0.117656,
      3,
      0.243406,
      1,
      0,
      1.672570,
      0,
      NULL,
      7,
      1,
      NULL,
      7.711546,
      4,
      2,
      3.056198,
      NULL,
      NULL,
      0.352192,
      3.022136,
      7,
      1.059394,
      3,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.893429,
      0.623805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.469146,
      3,
      0.091578,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      0.439558,
      2,
      0.514097,
      NULL,
      NULL,
      NULL,
      1.927560,
      5,
      1.486147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.566274,
      0,
      1,
      3.663202,
      0.042358,
      2,
      NULL,
      1,
      NULL,
      1.392961,
      0.351331,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.789931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.232840,
      '43010',
      '24141',
      '',
      0.667987,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


