set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '41',
      6,
      7,
      '1400423',
      NULL,
      1,
      3,
      0,
      '441420',
      NULL,
      '11-12-2003',
      51.887998,
      71.851800,
      0,
      NULL,
      1.419344,
      0,
      2,
      1,
      1.338594,
      1,
      0.674020,
      0.869589,
      0.097363,
      0,
      1,
      0,
      0,
      NULL,
      1.122938,
      1,
      4.071750,
      NULL,
      1.176923,
      NULL,
      1,
      3.425307,
      NULL,
      0,
      5,
      0,
      3.639875,
      1,
      NULL,
      NULL,
      0.387833,
      NULL,
      NULL,
      0.958862,
      NULL,
      0,
      2.357693,
      1.118230,
      0,
      1,
      0.829060,
      1.704059,
      1,
      3.349452,
      2.907381,
      1.361890,
      NULL,
      NULL,
      0.017121,
      1,
      1.978285,
      0.848056,
      1.597093,
      1,
      1,
      4,
      0,
      0,
      0.991881,
      1.861189,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.383326,
      2.803009,
      NULL,
      1,
      0,
      0.966846,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1.369173,
      0,
      0,
      NULL,
      0,
      0.531819,
      5.930834,
      0,
      0.233586,
      NULL,
      2.872161,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.172307,
      NULL,
      NULL,
      1,
      2,
      4,
      NULL,
      NULL,
      0.561504,
      6.473362,
      5.493687,
      NULL,
      2.265477,
      NULL,
      2,
      0,
      0,
      0,
      0,
      0.808229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250413,
      0,
      0,
      1,
      1.030696,
      0.062061,
      1.742228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308187,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.003642,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.540840,
      0.613298,
      NULL,
      NULL,
      0.150410,
      0,
      0.860633,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.423173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.688480,
      0.063073,
      1.391867,
      1.367270,
      0,
      2.724496,
      NULL,
      NULL,
      0.332914,
      3.917509,
      0.470199,
      1.948574,
      0.733469,
      1.210565,
      0.868453,
      NULL,
      1.601521,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '00234',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.687939,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


