set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      NULL,
      28.412868,
      NULL,
      '4101104',
      126,
      3,
      3,
      NULL,
      '411024',
      NULL,
      ' 5-10-1999',
      18.236343,
      49.452964,
      0.176421,
      NULL,
      NULL,
      1.982991,
      1,
      1,
      1,
      0,
      2,
      1,
      0,
      0.939527,
      5,
      NULL,
      1,
      6,
      4,
      0,
      7.091278,
      0,
      2.927251,
      NULL,
      8.773922,
      1.552365,
      0,
      1,
      1.908402,
      4.002454,
      5,
      0.998181,
      NULL,
      NULL,
      1.868370,
      NULL,
      NULL,
      5.382074,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      0.574284,
      0,
      NULL,
      NULL,
      3,
      2.401297,
      0,
      0.794466,
      2,
      1,
      1.428160,
      0.811109,
      1.533616,
      1,
      NULL,
      0,
      0,
      NULL,
      0.180417,
      NULL,
      NULL,
      0.675593,
      NULL,
      NULL,
      0.996152,
      7.801299,
      2.262839,
      1,
      3,
      0.197054,
      0.186556,
      1,
      1,
      0.572357,
      1.631438,
      0,
      0.673330,
      5.400800,
      1,
      0,
      0.973297,
      0,
      NULL,
      NULL,
      1.406697,
      0,
      4,
      0,
      0.484105,
      1,
      NULL,
      0,
      1,
      1.479608,
      NULL,
      3.919052,
      1.179439,
      0,
      3.582811,
      1.606839,
      NULL,
      2.390596,
      0.308804,
      NULL,
      6,
      NULL,
      1.258147,
      8.191357,
      6,
      0.014994,
      1,
      4,
      1,
      1,
      1.762151,
      3,
      1.861772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400541,
      0.655571,
      1,
      1,
      1,
      1.940777,
      0,
      1.545034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463095,
      NULL,
      9,
      NULL,
      1,
      0.548600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905556,
      6,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.495718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993791,
      0.383949,
      1.789492,
      1,
      NULL,
      1.516543,
      3.087408,
      0.834342,
      NULL,
      0.933677,
      NULL,
      NULL,
      1,
      0.007251,
      1.652973,
      0.158376,
      1.116054,
      1,
      0.058309,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425891,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.661979,
      2.411863,
      3,
      2,
      1.392853,
      NULL,
      2,
      1,
      '04412',
      '22334',
      '',
      0,
      '',
      '',
      NULL,
      0.935496,
      '',
      '',
      '',
      0.663672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


