set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      NULL,
      39,
      36,
      '1320222',
      125,
      4,
      2,
      1,
      '413444',
      2,
      ' 0-22-1979',
      NULL,
      23,
      0,
      NULL,
      0.240358,
      2.088669,
      0,
      NULL,
      1.275170,
      0,
      0,
      1,
      NULL,
      0.118018,
      NULL,
      NULL,
      0.445634,
      4.418519,
      2,
      1.769351,
      9,
      NULL,
      NULL,
      NULL,
      2.915610,
      1.767735,
      10.788813,
      NULL,
      1,
      1.399780,
      5,
      1,
      NULL,
      NULL,
      1.866962,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      0,
      1.510686,
      0.979362,
      2.324184,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      1.304619,
      1.974894,
      NULL,
      NULL,
      0.500795,
      1,
      NULL,
      3.265216,
      3.637176,
      0,
      0,
      0.771618,
      1,
      NULL,
      NULL,
      1.073805,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      6,
      4,
      0.540092,
      0,
      1.504929,
      NULL,
      NULL,
      2.566527,
      NULL,
      5,
      0,
      1.655988,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.490773,
      5.427586,
      0.973137,
      1,
      1,
      7.061916,
      0,
      5.464443,
      1,
      NULL,
      5,
      4,
      0.044183,
      2,
      NULL,
      3.896761,
      9.831101,
      1.243774,
      5,
      7.796658,
      3,
      NULL,
      5.220395,
      5.163492,
      0.450977,
      1.357189,
      NULL,
      3,
      0.930392,
      1,
      5.623798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.691151,
      0,
      2,
      0,
      1,
      0.613574,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.816478,
      NULL,
      0.466346,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701876,
      1.492031,
      9,
      NULL,
      0.722269,
      0,
      0.551740,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      0,
      3,
      NULL,
      2.952079,
      0.827915,
      2.697285,
      1.417574,
      1.011729,
      1.144156,
      NULL,
      0,
      0.012411,
      0.241624,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296865,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161889,
      1,
      1,
      2,
      1,
      1,
      0.228824,
      1,
      5.425031,
      '42430',
      '12230',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      5,
      4.781946,
      NULL,
      2.911390,
      1,
      0.269406,
      NULL,
      0.369989,
      3);
commit;
end;
/


