set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      NULL,
      33.073937,
      NULL,
      '4341431',
      244,
      4,
      NULL,
      1,
      '030141',
      3,
      ' 1- 4-1988',
      4.552978,
      1.759488,
      0.456176,
      NULL,
      17,
      1,
      3.017617,
      NULL,
      0.879778,
      3.988090,
      0.390353,
      0,
      0,
      1,
      3.451896,
      0.452233,
      NULL,
      5,
      0,
      1.995970,
      1,
      0.618191,
      6,
      NULL,
      2.344804,
      3,
      10,
      1,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970152,
      2,
      0.308619,
      1,
      NULL,
      3,
      NULL,
      1.585994,
      1,
      3,
      NULL,
      1,
      1.885672,
      1.239707,
      NULL,
      2,
      1.677204,
      1.127629,
      3,
      1.093493,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.109353,
      4,
      NULL,
      4.802103,
      2.758366,
      0.723818,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.612216,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.242604,
      5.836363,
      1.690490,
      1,
      1,
      NULL,
      0.858198,
      2,
      1.340347,
      0,
      1,
      4.073175,
      NULL,
      0.668918,
      7,
      3.604451,
      0.350139,
      0.353906,
      0,
      8.097033,
      0.318962,
      0.667992,
      4.318754,
      NULL,
      0.497062,
      1.046923,
      NULL,
      NULL,
      1.513854,
      1.415305,
      3.848443,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.863754,
      0.737058,
      NULL,
      0.140737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785398,
      NULL,
      1.324407,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848964,
      4.635395,
      1,
      NULL,
      1,
      0.496111,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705081,
      3,
      1.903989,
      1.982696,
      1.563352,
      2.228772,
      3,
      0.945426,
      0.557645,
      NULL,
      0.560039,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195900,
      0.971069,
      1.571215,
      1.881385,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693466,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156427,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.006190,
      0,
      NULL,
      0.908509,
      1,
      1.005562,
      NULL,
      1.904249,
      '41102',
      NULL,
      '',
      1.031168,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      0,
      3.427888,
      3,
      1.461160,
      2.300241,
      NULL,
      2.781946,
      NULL);
commit;
end;
/


