set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '03202201',
      1,
      5,
      '1042430',
      NULL,
      4,
      NULL,
      0,
      '220302',
      5,
      NULL,
      36.593251,
      1.228002,
      1,
      NULL,
      0,
      NULL,
      3.758359,
      1.497989,
      0,
      0.326237,
      1.659765,
      0.506247,
      2,
      1,
      0,
      1.838486,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      2.004055,
      1.481083,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.990732,
      0.235247,
      0.838830,
      NULL,
      NULL,
      0.372785,
      NULL,
      NULL,
      NULL,
      6.398634,
      1,
      3,
      1.530318,
      0,
      1.752473,
      2.119309,
      2,
      2.630156,
      2.074678,
      NULL,
      0,
      NULL,
      0,
      1.602359,
      NULL,
      1.397408,
      1,
      NULL,
      1,
      6,
      11,
      0,
      2,
      0.373584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      4,
      4,
      3.082077,
      9.648426,
      6.109404,
      NULL,
      NULL,
      5,
      0.757907,
      0.053814,
      0.058626,
      1.511431,
      0.934160,
      1,
      1.707963,
      0.308468,
      NULL,
      0,
      1.345146,
      9.908652,
      NULL,
      0,
      NULL,
      NULL,
      0.085770,
      5,
      NULL,
      0.462248,
      NULL,
      0.106389,
      1.111975,
      0.842246,
      4.597549,
      8,
      NULL,
      0.219970,
      4.776154,
      3,
      6.957223,
      7,
      9,
      5.843045,
      7,
      3,
      3.822768,
      3,
      NULL,
      NULL,
      0.449432,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      1,
      NULL,
      4,
      0.561816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.547952,
      4.373136,
      1,
      1,
      0,
      0.876411,
      NULL,
      NULL,
      NULL,
      0.572194,
      0.060358,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.178046,
      3,
      3.457355,
      1.522270,
      0.863321,
      3,
      NULL,
      1.483357,
      0.245474,
      1.284536,
      1,
      1.968102,
      0.734905,
      1.270866,
      1.074338,
      1.025255,
      1,
      1.201114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.024998,
      0,
      NULL,
      0.021933,
      '00044',
      '40212',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      1.792797,
      0,
      2.887545,
      2.416542,
      1.646492,
      NULL,
      NULL,
      1.173298);
commit;
end;
/


