set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      NULL,
      39,
      50,
      '2031214',
      53.362077,
      2,
      2.593351,
      3,
      '414234',
      0,
      ' 2- 6-1994',
      41.472066,
      49,
      0.184572,
      NULL,
      0.472671,
      0.226316,
      0,
      0.596242,
      1.350199,
      0,
      1.670836,
      1,
      NULL,
      1,
      NULL,
      1.620819,
      NULL,
      7,
      NULL,
      1,
      6.679026,
      NULL,
      NULL,
      2,
      8.160737,
      3,
      6,
      0,
      2.891448,
      1.890927,
      3.816524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635233,
      6.446114,
      2.030909,
      0,
      1.821928,
      NULL,
      3.975456,
      1.238946,
      2.570442,
      NULL,
      3.566562,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      0,
      5.254730,
      1,
      0.239990,
      NULL,
      NULL,
      0,
      1.364795,
      1,
      NULL,
      NULL,
      0.609097,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.597705,
      7,
      1.517463,
      6.971730,
      NULL,
      1.078602,
      NULL,
      0.138246,
      NULL,
      1,
      9.274806,
      0.248873,
      0,
      NULL,
      1.377809,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0.044443,
      3.779808,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.035084,
      1,
      1,
      4,
      9,
      5.486148,
      NULL,
      2,
      NULL,
      7.022643,
      NULL,
      NULL,
      9,
      4,
      3.076585,
      NULL,
      1.980225,
      1.972304,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.184034,
      1,
      1,
      0,
      1.431561,
      0.625670,
      0.564309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      7,
      NULL,
      2.864198,
      NULL,
      1.934276,
      NULL,
      NULL,
      NULL,
      1.355324,
      4.384012,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.798161,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.003195,
      1.367299,
      1,
      NULL,
      0.379752,
      NULL,
      0.816260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342326,
      1.606642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.427502,
      NULL,
      NULL,
      NULL,
      1.831955,
      0,
      0,
      0,
      1.675607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506733,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.667013,
      NULL,
      0.083618,
      NULL,
      NULL,
      NULL,
      4.314474,
      '30341',
      '02413',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      1,
      0.367460,
      3,
      NULL,
      3.818860,
      1,
      2.578630,
      3.167032);
commit;
end;
/


