set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      NULL,
      27.373186,
      10,
      NULL,
      NULL,
      2,
      2.646028,
      2,
      NULL,
      0,
      NULL,
      18,
      64.936648,
      NULL,
      NULL,
      0.987290,
      0,
      1.526323,
      NULL,
      0,
      1.925398,
      NULL,
      1,
      0,
      1,
      2,
      0.748290,
      0.163601,
      NULL,
      0,
      1.642152,
      11.143562,
      3.756103,
      NULL,
      3,
      2,
      1.088442,
      NULL,
      1,
      NULL,
      5.165503,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.336362,
      NULL,
      5.259224,
      NULL,
      1.165202,
      1.981195,
      1,
      1,
      NULL,
      1.455305,
      0.282133,
      2.747058,
      NULL,
      3.050250,
      0.671683,
      1.805479,
      NULL,
      0.920128,
      1.745594,
      1,
      2.365057,
      3,
      4.529088,
      0,
      0,
      2.397853,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.343352,
      NULL,
      2.979007,
      0.566235,
      7,
      6,
      7,
      4,
      NULL,
      0,
      5.501215,
      1.095321,
      1,
      5.470643,
      0,
      0,
      1,
      1.005297,
      0.354393,
      NULL,
      1.999941,
      0,
      8,
      0.656484,
      0.776799,
      0.252713,
      0.384544,
      NULL,
      3.965384,
      3,
      1,
      0,
      NULL,
      1.141005,
      3.594630,
      NULL,
      2.030884,
      4,
      1,
      6,
      NULL,
      0.564454,
      9,
      7,
      0,
      0,
      7.744246,
      0.592104,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531051,
      4,
      0,
      NULL,
      0.355794,
      1,
      2.001673,
      1.502048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.890586,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.898261,
      1.865531,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0,
      NULL,
      0.604006,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.593410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096048,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      2.307979,
      0,
      NULL,
      0.463116,
      1.057997,
      1.155389,
      0.302690,
      0.153107,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839337,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.600964,
      NULL,
      NULL,
      0.699714,
      0,
      1.492768,
      NULL,
      0,
      '23030',
      '00320',
      '',
      0.454515,
      '',
      '',
      NULL,
      2.896118,
      '01224',
      '',
      '',
      2,
      8.671947,
      NULL,
      3.482549,
      2,
      0,
      1.866446,
      2,
      2.107160);
commit;
end;
/


