set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '41203010',
      10,
      2.844331,
      '1011310',
      92.624857,
      4,
      0.074105,
      NULL,
      '301003',
      NULL,
      '11-21-1993',
      18,
      9,
      1.375534,
      NULL,
      5.019081,
      2,
      0,
      0.237583,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      4,
      1.907883,
      0,
      1,
      0.589327,
      5,
      10,
      1,
      0.790318,
      1.219208,
      1,
      3.021581,
      0,
      5.403398,
      NULL,
      NULL,
      NULL,
      1.494728,
      NULL,
      NULL,
      NULL,
      2.732070,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1.390232,
      NULL,
      NULL,
      0.161695,
      0,
      2.075452,
      1.060702,
      1.473117,
      0,
      0.058011,
      1,
      NULL,
      NULL,
      0.298599,
      11,
      0,
      0,
      4.723825,
      1,
      NULL,
      NULL,
      1.470813,
      NULL,
      NULL,
      0.092821,
      NULL,
      7,
      1.307488,
      NULL,
      3.713630,
      NULL,
      3.429715,
      7,
      NULL,
      0,
      2,
      1.102337,
      0.599575,
      NULL,
      NULL,
      1.301730,
      0.488229,
      0,
      NULL,
      1.032430,
      1,
      7.860077,
      1.563753,
      1.089191,
      2,
      NULL,
      1.770804,
      4.870908,
      2.675558,
      5.093150,
      0.093373,
      3,
      0.104095,
      1.202255,
      1.355010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.536392,
      NULL,
      2,
      NULL,
      0.523032,
      NULL,
      2,
      NULL,
      0.711161,
      1.553979,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.700811,
      NULL,
      0,
      0.943137,
      6.739480,
      4,
      0.366857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469456,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514119,
      NULL,
      NULL,
      NULL,
      NULL,
      7.331107,
      0,
      3.738581,
      1,
      NULL,
      NULL,
      0.374375,
      NULL,
      NULL,
      NULL,
      0,
      6.753066,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.192489,
      3.272433,
      3,
      1,
      2,
      2,
      2,
      1.530765,
      2,
      3.070986,
      2,
      NULL,
      0.045656,
      0.924886,
      1,
      NULL,
      1,
      0.706389,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.243417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4.381771,
      '43122',
      '10324',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      5.531429,
      1.369561,
      NULL,
      1,
      2,
      0,
      1,
      0);
commit;
end;
/


