set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2110',
      '24112403',
      NULL,
      10.932509,
      '4313221',
      316.233799,
      3,
      NULL,
      0,
      NULL,
      1,
      ' 9-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.988369,
      1.939747,
      0.389525,
      1.797593,
      0,
      0,
      NULL,
      0,
      0.559707,
      7,
      1,
      0,
      0,
      0,
      0,
      1,
      3,
      NULL,
      3,
      1,
      1.972294,
      1.132011,
      0,
      3,
      4.750190,
      4,
      1,
      NULL,
      NULL,
      0.894458,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.726810,
      1,
      1.044734,
      NULL,
      1.135618,
      1.172930,
      0,
      0.113544,
      1.755709,
      2,
      NULL,
      NULL,
      2.974826,
      NULL,
      0.594233,
      0.046609,
      3.331454,
      0.068751,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.543376,
      1.465778,
      3.512182,
      1.880364,
      5.931807,
      8,
      4,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0.805102,
      2,
      1.506725,
      1.387555,
      0.762692,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      4.205862,
      5,
      3,
      6.291813,
      7,
      1,
      9.823940,
      6.651750,
      0,
      2,
      NULL,
      0.779773,
      1,
      0.292477,
      3,
      1.607509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      2.280786,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8,
      1,
      2.055784,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.241469,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.465905,
      3.128776,
      0.563384,
      1,
      1,
      0,
      3.671279,
      0.607808,
      0.735569,
      1,
      0.521546,
      0.323107,
      1.478759,
      0.694976,
      1,
      NULL,
      1.483150,
      1.266712,
      1.229440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.813424,
      '40103',
      '22202',
      NULL,
      0.038245,
      '',
      '',
      '',
      0.699401,
      NULL,
      '',
      '',
      2.171928,
      2.511051,
      0,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL);
commit;
end;
/


