set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12440321',
      64,
      71.513227,
      '4112122',
      109.160210,
      NULL,
      3,
      0,
      '021422',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.745156,
      0,
      3,
      1,
      1,
      1.703254,
      1,
      NULL,
      1,
      0,
      7.629716,
      1.424632,
      0.348712,
      11,
      0.339134,
      2,
      NULL,
      1,
      4.436101,
      3.922808,
      1,
      0,
      11,
      NULL,
      5,
      1,
      2.141505,
      1.953104,
      NULL,
      NULL,
      0.969080,
      NULL,
      NULL,
      1,
      2,
      2,
      2.853699,
      1,
      1.729294,
      NULL,
      0,
      2.461974,
      0,
      0.660869,
      2,
      3,
      2.611157,
      NULL,
      0,
      1.889069,
      NULL,
      0.304038,
      0.077870,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.241817,
      NULL,
      NULL,
      0.887415,
      NULL,
      3.620718,
      0.166907,
      3,
      4,
      6,
      0.385264,
      2,
      1.030449,
      3,
      1.843455,
      1,
      5.042296,
      1,
      1,
      0,
      0.258838,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.621643,
      NULL,
      4.586401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.265765,
      1.840436,
      3.055865,
      3.562427,
      5,
      0,
      6.904173,
      NULL,
      9,
      NULL,
      11.785255,
      6,
      0,
      6,
      NULL,
      4,
      0.065595,
      1.220421,
      1.642118,
      7.698661,
      1.283148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.895428,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.855254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.804981,
      0.522540,
      NULL,
      1,
      2.409498,
      0,
      0.944138,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1.265209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.259343,
      3.527294,
      NULL,
      1.364845,
      NULL,
      1,
      NULL,
      1.180993,
      2.096235,
      NULL,
      0.049622,
      1,
      1.561500,
      0.382136,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '14210',
      '43113',
      '',
      1.605797,
      '',
      NULL,
      '',
      1.540326,
      '33001',
      '',
      '',
      4.669710,
      9,
      2,
      0,
      NULL,
      3,
      1.371142,
      0,
      1);
commit;
end;
/


