set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2003',
      '02432012',
      81.547889,
      47.758314,
      '4021120',
      148,
      NULL,
      2,
      0,
      NULL,
      5.670638,
      ' 2-28-1988',
      54,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.818460,
      0,
      0.280212,
      1.839904,
      0.522870,
      3.639522,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.221501,
      NULL,
      NULL,
      1.644108,
      1,
      4.646903,
      0,
      5.388033,
      2,
      3.925235,
      0.671267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.110046,
      3.576134,
      1.547388,
      1,
      1.643137,
      1,
      0.898183,
      3.917641,
      0.101940,
      1,
      3.079168,
      2.392193,
      1,
      1,
      0.327942,
      1.828308,
      1.317787,
      NULL,
      1,
      1,
      8,
      NULL,
      0,
      NULL,
      2.722064,
      1.629834,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      6.897547,
      5.599999,
      NULL,
      6.442850,
      8.171039,
      7,
      0.829544,
      0.947805,
      1.937971,
      1,
      0,
      1.433023,
      3,
      1,
      0.751068,
      0,
      0,
      0,
      NULL,
      0,
      1,
      3,
      1.851848,
      1.447638,
      0.102386,
      1.316093,
      0.727914,
      NULL,
      NULL,
      NULL,
      NULL,
      5.270638,
      0.908953,
      1.464924,
      1.477473,
      7.318879,
      8,
      5.871692,
      3,
      8.475584,
      NULL,
      6,
      4,
      NULL,
      4,
      NULL,
      6.180116,
      NULL,
      1.289730,
      1.546207,
      1.059738,
      1.778973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.143519,
      2.569981,
      1.361149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.643146,
      1.145396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345258,
      3.902841,
      1,
      1,
      NULL,
      1,
      2.077534,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.448951,
      1,
      1,
      1.586434,
      NULL,
      0,
      1.572754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.880605,
      '32410',
      '',
      NULL,
      1,
      0,
      0.323190,
      2.213157,
      NULL,
      1,
      2,
      3.195618,
      0);
commit;
end;
/


