set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0302',
      NULL,
      40,
      NULL,
      '2222431',
      250,
      5,
      NULL,
      1,
      NULL,
      2,
      '10-18-1998',
      20,
      28,
      1.571357,
      NULL,
      1,
      0.107890,
      1.917765,
      1.825925,
      0.116348,
      1.029724,
      0,
      0,
      NULL,
      0.517795,
      0,
      1.835675,
      NULL,
      4.702640,
      NULL,
      0,
      1.257259,
      1.165531,
      6.576740,
      6.151857,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.487708,
      0.171274,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637430,
      NULL,
      4.886369,
      2.021870,
      1,
      1,
      0,
      3,
      1.834888,
      NULL,
      NULL,
      3,
      2.288539,
      0.956506,
      0.489024,
      0.609974,
      1.845331,
      0,
      1,
      0.328975,
      1.796321,
      3,
      9,
      1,
      NULL,
      NULL,
      0.201161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      2.081621,
      1.746796,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.122003,
      NULL,
      NULL,
      1,
      NULL,
      0.091542,
      1.776001,
      0,
      NULL,
      1,
      0.909640,
      NULL,
      0.691725,
      NULL,
      0,
      NULL,
      0.202960,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.363564,
      4,
      0.517626,
      NULL,
      6.395510,
      6.142517,
      6,
      NULL,
      6,
      6,
      7,
      2,
      0,
      9,
      2.147422,
      1.432569,
      1,
      1.382076,
      1,
      1.535175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0.005783,
      1.508772,
      3.852806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3,
      2.229605,
      1.956142,
      NULL,
      0.895973,
      NULL,
      NULL,
      NULL,
      1.599003,
      4,
      1.356373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.298029,
      NULL,
      0,
      0.081861,
      1.192501,
      2,
      0,
      0,
      0,
      1.993081,
      0.468076,
      1,
      1.724078,
      1.105536,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.835280,
      '13323',
      '40111',
      '',
      0.553904,
      '',
      '',
      '',
      1.438483,
      NULL,
      '',
      '',
      0.131783,
      0.749520,
      3,
      3.544398,
      1,
      3,
      2.950088,
      NULL,
      2.986228);
commit;
end;
/


