set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '12',
      23.106064,
      6.463025,
      NULL,
      16.008393,
      0,
      NULL,
      NULL,
      NULL,
      2.703163,
      ' 5-13-1989',
      41,
      4.369645,
      NULL,
      NULL,
      0.969334,
      1.643283,
      0,
      1,
      0.261844,
      0.347759,
      1.233820,
      0,
      NULL,
      0.177949,
      4,
      1,
      NULL,
      0.628424,
      0.689661,
      3,
      7.638605,
      3,
      1,
      NULL,
      0.801880,
      2,
      4,
      1,
      3.172326,
      0.737026,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.983197,
      3,
      NULL,
      0,
      NULL,
      0.300228,
      0,
      3.184303,
      3.990805,
      NULL,
      1,
      2.433703,
      1,
      1.773660,
      2.539196,
      0,
      1,
      0.258998,
      0,
      NULL,
      1,
      1,
      1.787010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.234175,
      1,
      1,
      NULL,
      0.623245,
      0.176967,
      1.987551,
      1,
      2.764352,
      0.053259,
      NULL,
      NULL,
      NULL,
      0.901487,
      NULL,
      1.365159,
      0.532968,
      NULL,
      NULL,
      0,
      NULL,
      3.551449,
      1,
      1.951868,
      0,
      1,
      3,
      0,
      3.781028,
      0.068587,
      0.069357,
      0,
      4,
      1.560235,
      NULL,
      5.887454,
      6,
      3.116726,
      2,
      2.648007,
      1,
      9,
      5.799659,
      0.566568,
      1,
      NULL,
      1.594077,
      1.651941,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596440,
      1.607987,
      0,
      NULL,
      1.044922,
      NULL,
      1.865217,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999185,
      0.267434,
      NULL,
      1,
      2,
      3.883441,
      0,
      3.491646,
      3,
      1.610721,
      1,
      NULL,
      2.356236,
      0,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.688626,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555055,
      3.643713,
      2,
      3.410553,
      0,
      0.283621,
      1,
      1,
      0,
      3,
      0.890299,
      0.257538,
      0.512346,
      0,
      0.301367,
      NULL,
      0,
      1.487568,
      1.938116,
      0.815705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '22113',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.848544,
      '',
      '',
      '',
      3.484011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


