set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23',
      18.200856,
      28.546054,
      '3102343',
      10.288923,
      NULL,
      2,
      3,
      NULL,
      1,
      ' 5-19-2000',
      14,
      58.110673,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.887205,
      0.097176,
      3.919253,
      0,
      1.750500,
      1.820532,
      NULL,
      NULL,
      NULL,
      4.878131,
      7.307118,
      2.758044,
      0,
      2,
      0.647595,
      4.790879,
      0.139366,
      1,
      4.877533,
      0,
      NULL,
      0.611798,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.241895,
      0,
      NULL,
      3.943016,
      3,
      NULL,
      1,
      1.341439,
      3,
      NULL,
      1.386005,
      3.765245,
      0.152876,
      0.842213,
      0.232544,
      2.838102,
      3.434716,
      6.026670,
      5.583146,
      1.294659,
      0.749348,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.784304,
      5,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.047001,
      1.619401,
      1,
      1,
      NULL,
      0.089892,
      NULL,
      0.106620,
      NULL,
      NULL,
      NULL,
      0.530244,
      1,
      0.473041,
      NULL,
      1.876198,
      1.568693,
      0.707730,
      0.732708,
      NULL,
      NULL,
      NULL,
      1.790223,
      2,
      0,
      6,
      7,
      8.382002,
      2.400179,
      9,
      NULL,
      0,
      3,
      3.146461,
      0.542673,
      1,
      3.425845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.821511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.952363,
      NULL,
      NULL,
      NULL,
      0.763366,
      1.409707,
      NULL,
      4,
      0,
      2,
      0,
      0.837190,
      NULL,
      NULL,
      0.301200,
      4.302138,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319821,
      2,
      3.094782,
      0,
      1,
      2.341126,
      2.974054,
      NULL,
      1,
      0,
      1.439259,
      0,
      0.937758,
      1,
      0,
      1.350678,
      0.430582,
      1.745437,
      1.661787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '14033',
      NULL,
      '',
      1.557846,
      '',
      '',
      NULL,
      0.895579,
      '',
      '',
      '',
      4.024372,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      3.392731,
      5);
commit;
end;
/


