set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14311322',
      20.610720,
      14,
      '3300021',
      6.567601,
      5,
      1.657333,
      0,
      '001104',
      4,
      ' 5-10-1989',
      NULL,
      10.087782,
      0.020710,
      NULL,
      NULL,
      3.052873,
      0.631889,
      1,
      1,
      0.539695,
      0.474911,
      NULL,
      0.231213,
      0,
      7,
      1.282595,
      1.357997,
      NULL,
      0.731266,
      4,
      3.915339,
      3,
      1,
      0.588406,
      3,
      2.690426,
      NULL,
      1,
      2.912489,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.307223,
      NULL,
      NULL,
      5.968930,
      NULL,
      7.654748,
      2.037327,
      1,
      NULL,
      1.157027,
      0.415129,
      0.997108,
      0,
      NULL,
      0,
      1,
      2.974198,
      NULL,
      1,
      1.217257,
      3.857932,
      3,
      8,
      2,
      NULL,
      4.748172,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.320138,
      NULL,
      NULL,
      1.839912,
      1,
      0.752269,
      1,
      1,
      2.342208,
      2,
      1.076813,
      0.551682,
      6,
      7.585614,
      5.327658,
      1,
      1,
      1,
      1.565467,
      NULL,
      NULL,
      0.697031,
      NULL,
      1.893755,
      1.390084,
      0,
      0.611097,
      0.428371,
      1,
      NULL,
      0.449555,
      1.295360,
      0,
      0,
      NULL,
      1,
      NULL,
      1.015488,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      9,
      2,
      0,
      4.627152,
      0,
      0,
      NULL,
      NULL,
      0.559826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661613,
      0.149174,
      NULL,
      NULL,
      0.224810,
      1.609056,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781539,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555134,
      1,
      NULL,
      NULL,
      NULL,
      1.564193,
      3.408952,
      NULL,
      0,
      4.835613,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.424401,
      NULL,
      0.331797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914150,
      NULL,
      2,
      1.280055,
      2.155417,
      2,
      3.681235,
      NULL,
      1,
      2,
      0.971652,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.610862,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '42132',
      '',
      '',
      0.790805,
      '',
      NULL,
      '',
      1.402613,
      '',
      NULL,
      '',
      1,
      1.105874,
      3,
      2.968013,
      NULL,
      1.009913,
      0.332677,
      3,
      3.173607);
commit;
end;
/


