set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      '10022210',
      26,
      35.967455,
      '2214021',
      8,
      3,
      1.880650,
      2,
      '311240',
      3,
      ' 4-28-1981',
      NULL,
      35,
      0,
      NULL,
      NULL,
      1.219929,
      0,
      1,
      0,
      NULL,
      0.393373,
      NULL,
      NULL,
      1,
      4.673196,
      1.933342,
      1,
      8.820874,
      6,
      4,
      NULL,
      3.002616,
      0.220291,
      1,
      6,
      1,
      7,
      0,
      5,
      3.535528,
      NULL,
      0.729161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.211183,
      1,
      1.620945,
      2.708384,
      0.794059,
      NULL,
      1.826508,
      2.274344,
      0.760599,
      NULL,
      3,
      2,
      2.491653,
      0,
      5.024058,
      3,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.622133,
      NULL,
      NULL,
      0.232906,
      NULL,
      1,
      0.564400,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      NULL,
      5.049254,
      1.075299,
      NULL,
      0.483758,
      1,
      1.291087,
      NULL,
      0,
      1.399229,
      1.992924,
      NULL,
      NULL,
      0.506617,
      1.515939,
      0.020807,
      1.897110,
      1,
      1,
      0.900150,
      0,
      0,
      NULL,
      0,
      1,
      1.922606,
      NULL,
      3,
      1,
      7,
      5.354745,
      2,
      1.051562,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      3.452874,
      1.890112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764097,
      0,
      1,
      1,
      0.417016,
      1.949695,
      1.947923,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966239,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288483,
      4.836345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0,
      2.963137,
      3,
      1.697791,
      0.682327,
      2.560218,
      1.576356,
      0,
      0,
      1.393218,
      1.007125,
      0,
      0.173703,
      0.669683,
      0,
      0.236119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.887224,
      '11314',
      '',
      '',
      0.669810,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      3.513298,
      2,
      3,
      0.464389,
      2,
      NULL,
      NULL,
      3.749592);
commit;
end;
/


