set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33143003',
      11,
      26,
      '1431103',
      4,
      5,
      2.379315,
      NULL,
      '212040',
      2,
      ' 6- 9-1981',
      23.659769,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.150788,
      1.339585,
      0,
      0.802561,
      1.789509,
      NULL,
      1,
      1,
      1,
      8,
      6.150418,
      11.760508,
      NULL,
      NULL,
      1.266540,
      11,
      9,
      0.453284,
      0,
      0.211488,
      0,
      0.375472,
      1,
      NULL,
      NULL,
      0.575344,
      NULL,
      NULL,
      NULL,
      0.344258,
      2.469707,
      NULL,
      0.407464,
      1.885492,
      0,
      1,
      0,
      0.133073,
      NULL,
      3.352745,
      0.996665,
      2.991558,
      0.057886,
      1.443370,
      NULL,
      0,
      2,
      1,
      3,
      1,
      0.819325,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.853778,
      1,
      NULL,
      NULL,
      6.042498,
      6.404524,
      1.323734,
      1,
      NULL,
      5.602156,
      3.013556,
      NULL,
      0.021057,
      1.256604,
      0,
      1.820086,
      NULL,
      1.399288,
      NULL,
      0,
      0.556333,
      0,
      5.638017,
      0.630688,
      0,
      NULL,
      0.075683,
      1.030169,
      0,
      0,
      0.820527,
      0,
      1,
      0,
      0.798323,
      1.848249,
      3.797976,
      2.283681,
      4,
      NULL,
      4.835113,
      3,
      10,
      NULL,
      4,
      3.651974,
      0.239043,
      2.032938,
      0,
      0.673179,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.128751,
      0,
      NULL,
      1.163516,
      0,
      1.175827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469963,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.230427,
      NULL,
      4,
      5.049313,
      0.644105,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099411,
      0,
      3.721248,
      0,
      1.872502,
      0,
      2.374758,
      1,
      0,
      NULL,
      1.437859,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.151552,
      1.760092,
      1.147543,
      1.634816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '33412',
      '',
      '',
      1.631270,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      5,
      3.030091,
      3.872448,
      1,
      3.220220,
      2,
      1.666962,
      3.698516,
      0);
commit;
end;
/


