set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '32334211',
      10.247964,
      39.494763,
      '2413244',
      21.184642,
      4,
      2.857026,
      1,
      '024132',
      0,
      NULL,
      13,
      44.498118,
      0.158927,
      NULL,
      NULL,
      2.988042,
      1.284616,
      1.648360,
      0.864628,
      0,
      0.790330,
      0,
      NULL,
      0,
      2,
      0.781051,
      1,
      1,
      9,
      NULL,
      9,
      1.371295,
      0,
      0.519977,
      NULL,
      3.505034,
      NULL,
      0,
      NULL,
      0.028039,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      7.610793,
      NULL,
      NULL,
      NULL,
      1.225468,
      2.664572,
      1,
      NULL,
      NULL,
      3,
      1,
      0.794654,
      NULL,
      0.133685,
      2,
      3,
      NULL,
      3.009623,
      0,
      NULL,
      0.042307,
      2,
      NULL,
      0,
      5.856550,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.818395,
      0.580799,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      7,
      5.917858,
      0.268070,
      NULL,
      NULL,
      1.475309,
      NULL,
      1,
      0,
      0.472522,
      NULL,
      0,
      1.244069,
      NULL,
      1.974587,
      0,
      0.411766,
      NULL,
      0.679480,
      1.914772,
      NULL,
      0.387493,
      0.471500,
      NULL,
      1,
      0.573558,
      NULL,
      NULL,
      7.546237,
      NULL,
      NULL,
      5.432697,
      7.846475,
      4.879780,
      11.624814,
      2.603852,
      1,
      1,
      1,
      NULL,
      1.040845,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.938442,
      0.917091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.217550,
      1.826766,
      NULL,
      NULL,
      NULL,
      4,
      1.675935,
      NULL,
      4,
      0,
      NULL,
      1.736994,
      1,
      NULL,
      NULL,
      0.943596,
      3.411321,
      0.224098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      2.199604,
      3,
      2,
      0.327800,
      1.163904,
      3.780768,
      1.997054,
      1,
      1.979915,
      1.457260,
      0,
      1,
      0.084522,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.766209,
      '21032',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.079830,
      '',
      '',
      '',
      NULL,
      1,
      0,
      NULL,
      2,
      3.865335,
      0.247381,
      NULL,
      0);
commit;
end;
/


