set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '11434143',
      38,
      44.088706,
      NULL,
      73.918876,
      NULL,
      2,
      2,
      '144211',
      NULL,
      '10-17-1995',
      26,
      37.327516,
      0,
      NULL,
      0,
      0.786687,
      2,
      0,
      0.627856,
      0,
      0,
      1.174295,
      0,
      NULL,
      6,
      1.539455,
      1.964347,
      3.939808,
      11,
      3.537975,
      9,
      NULL,
      0.577819,
      0,
      6.803631,
      NULL,
      NULL,
      NULL,
      NULL,
      2.100319,
      NULL,
      1.769204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      8.935411,
      2,
      1.416485,
      NULL,
      3,
      0.950969,
      0.488368,
      2.776712,
      1,
      0.792106,
      NULL,
      2,
      1.874367,
      0.341143,
      0.503250,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.905910,
      NULL,
      NULL,
      1.252908,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.224294,
      1,
      2,
      1.952985,
      0,
      1.680362,
      NULL,
      7.497285,
      5.432618,
      1.820239,
      0.094749,
      0.442769,
      0.862245,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.497643,
      0,
      0,
      NULL,
      1.488853,
      0.041205,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.525698,
      5.751140,
      3,
      NULL,
      NULL,
      5,
      7,
      5.382737,
      2,
      3.299284,
      1.484925,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.490157,
      1,
      0,
      0,
      1.801182,
      0.084905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1.926174,
      NULL,
      0.120574,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187569,
      NULL,
      1.251759,
      1.644486,
      3.852307,
      1,
      5,
      0,
      NULL,
      NULL,
      0.523006,
      1.977059,
      1.836636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3,
      2.992712,
      2.928133,
      1,
      NULL,
      1.230833,
      0.777471,
      NULL,
      1,
      0,
      0.103341,
      NULL,
      0,
      NULL,
      1.245236,
      0.952624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '42212',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      0,
      2.994457,
      6,
      NULL,
      5,
      3,
      NULL,
      2);
commit;
end;
/


