set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '34014041',
      55.954603,
      10.074914,
      '4402044',
      106.448078,
      2,
      3.182089,
      2,
      NULL,
      NULL,
      ' 0-29-1996',
      41.523301,
      26,
      1.887022,
      NULL,
      6,
      1.847929,
      NULL,
      1,
      1.052060,
      NULL,
      2,
      0,
      1,
      0.354057,
      11,
      NULL,
      1,
      NULL,
      7.220565,
      0.960402,
      7.981013,
      2,
      1,
      1.892784,
      NULL,
      3,
      1,
      NULL,
      2.715259,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.220630,
      NULL,
      NULL,
      7.713168,
      5.731116,
      10,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      2.457622,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      2.068772,
      2,
      8.832932,
      0.045534,
      10.081224,
      2.936846,
      NULL,
      1,
      4.598344,
      1,
      NULL,
      NULL,
      0.739827,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.133136,
      2.782437,
      0.344725,
      0,
      0.639375,
      4,
      3,
      NULL,
      0,
      0.139186,
      1,
      0,
      1.238430,
      0,
      0.692722,
      NULL,
      0.219691,
      1.422138,
      1,
      0,
      1.681876,
      1.487453,
      0,
      1.154037,
      0,
      0,
      NULL,
      1.814847,
      1,
      0,
      0.995191,
      1.573661,
      1.803287,
      7.843433,
      5,
      7.654033,
      0.669593,
      1.636201,
      1.170718,
      1,
      NULL,
      7,
      3,
      1.494916,
      2.248343,
      1,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694466,
      0,
      0,
      NULL,
      1.383123,
      1,
      1.523309,
      1.258713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.112756,
      3.284467,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.283313,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932620,
      1,
      2.698822,
      NULL,
      4,
      0,
      3.634103,
      1,
      NULL,
      NULL,
      0.742010,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.747896,
      1,
      2.993541,
      1.968519,
      3.665722,
      NULL,
      1,
      0,
      2,
      2,
      1.290062,
      0.133249,
      0,
      0.169516,
      NULL,
      0,
      1.213399,
      1.506136,
      1.836838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.342390,
      '12402',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      5.117098,
      1,
      3.917642,
      3.519886,
      NULL,
      5.582991,
      1,
      NULL,
      3.947375);
commit;
end;
/


