set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      NULL,
      NULL,
      47,
      '0023213',
      59,
      5,
      2.982964,
      1,
      '404313',
      NULL,
      ' 4-24-1982',
      40.821672,
      NULL,
      1,
      NULL,
      1.049612,
      0.756471,
      0.347586,
      1.178663,
      1,
      0.014066,
      NULL,
      1.057804,
      0,
      0,
      4.654817,
      0.530539,
      NULL,
      4.544981,
      3.843788,
      7,
      NULL,
      4,
      0.496832,
      2.285716,
      3.033704,
      0.817984,
      0,
      0,
      1,
      3,
      NULL,
      1.223726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      9,
      6,
      NULL,
      1,
      1,
      3,
      3,
      0.522584,
      1.947723,
      2,
      2.115365,
      0,
      0.089209,
      1.301977,
      1,
      0,
      1.812011,
      NULL,
      1,
      3.826813,
      2.704948,
      5,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.095455,
      NULL,
      NULL,
      1,
      1.054201,
      NULL,
      1,
      0,
      NULL,
      1,
      1.393184,
      0.657863,
      3.357763,
      0,
      1.529450,
      1,
      2.960685,
      0,
      1.145392,
      0.727377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962245,
      1,
      1.077810,
      1,
      1,
      0.224002,
      1.568645,
      0.224316,
      1.927741,
      1.593191,
      NULL,
      0.927635,
      1,
      1,
      1.182731,
      1,
      6,
      3,
      6.997484,
      NULL,
      NULL,
      0,
      6.130015,
      NULL,
      1,
      1.242877,
      1.601763,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509164,
      NULL,
      0,
      1,
      1,
      1.578834,
      0.409303,
      0.028346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755768,
      1,
      3,
      1,
      1.331224,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.002443,
      4,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.378412,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027460,
      0,
      3.261584,
      NULL,
      2,
      2,
      3.115592,
      0,
      NULL,
      3.151241,
      0,
      NULL,
      1.314409,
      1,
      1,
      1.091099,
      1,
      0.918266,
      1,
      0.445420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.677891,
      '34023',
      NULL,
      '',
      1.975141,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.955701,
      3,
      NULL,
      2.940237);
commit;
end;
/


