set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '14043003',
      62,
      15,
      NULL,
      83.689246,
      NULL,
      NULL,
      0,
      '303123',
      4,
      ' 2- 3-2003',
      NULL,
      16,
      0,
      NULL,
      1,
      0.938362,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      8,
      0.458266,
      0,
      3,
      5,
      6,
      2,
      0.846483,
      0,
      0,
      5,
      NULL,
      1.864831,
      NULL,
      1.549205,
      1.912385,
      2,
      0,
      NULL,
      NULL,
      1.139754,
      NULL,
      NULL,
      9.842202,
      9.057418,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.501776,
      2.723128,
      NULL,
      0.555224,
      1.093213,
      3,
      1,
      1,
      0.335242,
      1.875256,
      2,
      7.153724,
      5,
      5,
      8,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.147346,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.906053,
      0,
      0.651220,
      0,
      2,
      2,
      0.819384,
      1,
      4.465787,
      0,
      NULL,
      0.011565,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      2,
      1,
      5,
      1,
      NULL,
      6,
      7,
      2,
      5,
      0.333321,
      6.849632,
      8.878403,
      5.051302,
      5.319193,
      5,
      1,
      3.066281,
      1,
      0,
      3.877094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.287747,
      NULL,
      0,
      0.604640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.066331,
      2.883918,
      0,
      NULL,
      NULL,
      0,
      0,
      1.809698,
      2.264193,
      4.551993,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0.964954,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.303568,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      0.655596,
      1.840427,
      0,
      1.113331,
      1,
      1,
      1,
      1.153647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44434',
      '',
      '',
      0.431818,
      '',
      '',
      '',
      1.707098,
      '',
      NULL,
      '',
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      0.491760,
      NULL);
commit;
end;
/


