set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2212',
      NULL,
      61,
      10.778015,
      '0034231',
      20.670251,
      4,
      1.309794,
      2,
      '223042',
      5,
      '11-13-1996',
      28,
      45,
      0.122393,
      NULL,
      0,
      2,
      1,
      1.826951,
      0.917542,
      1,
      0.526096,
      NULL,
      2.460594,
      1,
      1,
      0,
      1.387067,
      8,
      1,
      0.859030,
      4.002519,
      NULL,
      0.770177,
      1.234943,
      6.480193,
      1,
      3,
      0,
      5,
      NULL,
      3,
      0.015101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.255138,
      3,
      5.390953,
      3,
      NULL,
      1,
      2,
      3,
      1,
      1.838269,
      0,
      1,
      1,
      1,
      NULL,
      2,
      1.540514,
      NULL,
      NULL,
      NULL,
      5,
      7,
      3,
      1,
      NULL,
      5.722767,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.253051,
      1,
      1.400814,
      2,
      1.307841,
      NULL,
      1.476596,
      2.115861,
      NULL,
      NULL,
      1,
      5.185780,
      NULL,
      0,
      1,
      NULL,
      1.129714,
      NULL,
      1,
      0,
      1.886308,
      NULL,
      0.141141,
      0.917407,
      0,
      0.548283,
      0.842183,
      NULL,
      1,
      1,
      1.732867,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      4,
      3.546373,
      5.430984,
      0,
      2.442324,
      3,
      5,
      NULL,
      3.120844,
      0,
      1.613281,
      1,
      NULL,
      0.346371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.808794,
      NULL,
      0,
      NULL,
      1.619707,
      1,
      0.434228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.403836,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.065608,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.308344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.323820,
      0.125089,
      1,
      2,
      1,
      2,
      0.191612,
      0.414076,
      0,
      1,
      1.382223,
      0,
      0,
      0.284699,
      0.794610,
      1,
      1,
      1.198605,
      1.937512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '',
      0.216690,
      '',
      '',
      '',
      1.732386,
      '',
      '',
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.296814,
      NULL,
      3.669670);
commit;
end;
/


