set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0343',
      '22331132',
      19,
      16,
      '3411141',
      NULL,
      6,
      2,
      NULL,
      '301212',
      0.071594,
      ' 3- 5-2000',
      NULL,
      29,
      0,
      NULL,
      11,
      3.016156,
      1,
      1,
      0,
      NULL,
      1.576159,
      1,
      3,
      NULL,
      2,
      1.103270,
      1.312266,
      9.199348,
      3,
      2,
      NULL,
      0.612789,
      NULL,
      1,
      NULL,
      4,
      6,
      1,
      2,
      3.533746,
      1.596481,
      NULL,
      NULL,
      NULL,
      1.246070,
      NULL,
      NULL,
      0,
      1.700645,
      NULL,
      NULL,
      2,
      NULL,
      0.595710,
      0.018431,
      1.900420,
      1,
      3,
      0,
      0.495409,
      NULL,
      NULL,
      1.514961,
      NULL,
      0,
      1.135797,
      1,
      0,
      2.253773,
      NULL,
      1,
      0,
      2.852491,
      0.433153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.553477,
      0.635691,
      1.275799,
      0,
      NULL,
      1.693822,
      NULL,
      1,
      4,
      2,
      1,
      1,
      4.376422,
      NULL,
      1.112892,
      0,
      1.896510,
      NULL,
      NULL,
      1.544509,
      NULL,
      1.864942,
      0.309306,
      NULL,
      1.558695,
      1,
      1.128181,
      1,
      NULL,
      0.533087,
      1.177392,
      0.906990,
      1,
      0,
      1,
      NULL,
      7.025449,
      NULL,
      0.056098,
      5,
      2.156701,
      4.005406,
      6.659278,
      9.196844,
      4,
      NULL,
      NULL,
      3.683061,
      1,
      0,
      3,
      1.618296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.503207,
      0,
      1.308146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.071263,
      0.692417,
      NULL,
      NULL,
      0.236495,
      0.791256,
      1.483457,
      3.841775,
      1,
      NULL,
      NULL,
      NULL,
      0.215539,
      1.084178,
      0,
      6.282516,
      0.448713,
      2,
      0.137667,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.077477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.756523,
      1,
      1,
      0.910469,
      NULL,
      3.779178,
      0.702606,
      1,
      1.238143,
      0.466743,
      0.439660,
      0.207083,
      0.237684,
      1,
      1.763095,
      0,
      1,
      1.422154,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.082052,
      '20242',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      0.751000,
      NULL,
      0,
      2,
      NULL,
      1,
      0);
commit;
end;
/


