set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3343',
      '14420240',
      68.400044,
      12.894880,
      NULL,
      123,
      6,
      2,
      0,
      '420133',
      0.016577,
      ' 9- 7-1996',
      NULL,
      11.244863,
      0.110835,
      NULL,
      8,
      3.087955,
      0.852468,
      1,
      0.881128,
      0,
      1.099451,
      1,
      2,
      0.387635,
      5,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      3,
      0.221840,
      0.032697,
      0.757081,
      NULL,
      9,
      0,
      4,
      2,
      0.882309,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.371931,
      8.739389,
      5,
      3.318584,
      NULL,
      1.436384,
      1.297313,
      0.670622,
      0,
      0.048987,
      0.331899,
      2.840220,
      1,
      2.238159,
      0,
      NULL,
      2,
      NULL,
      0,
      3.275038,
      2.194976,
      5.498941,
      2.848868,
      1,
      0,
      1.454617,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.144893,
      1.068960,
      1,
      1.358462,
      0,
      3,
      0,
      0.985307,
      0.747702,
      2.238920,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.692164,
      0,
      0.730626,
      1,
      NULL,
      0,
      1.734420,
      1.627699,
      NULL,
      0,
      0.594483,
      0.813541,
      1.530363,
      NULL,
      5.294976,
      1,
      5.926561,
      4,
      7.261613,
      1.568577,
      5.843188,
      5,
      4.843830,
      6,
      4,
      2.484599,
      NULL,
      1.654195,
      3,
      1.062154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.935124,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902351,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.106705,
      1.676056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0.193433,
      NULL,
      1.248260,
      NULL,
      NULL,
      NULL,
      0.347041,
      1.178388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.945428,
      NULL,
      1,
      1.873402,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.933417,
      1.407342,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.165957,
      '02001',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      2,
      0.372543,
      1.583225,
      2.570160,
      0,
      3,
      0.425807);
commit;
end;
/


