set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2123',
      '34302343',
      NULL,
      14,
      '4013001',
      NULL,
      4,
      3.641105,
      0,
      '202132',
      5.191573,
      ' 0-10-1986',
      35,
      51.010569,
      0.775190,
      NULL,
      0.131350,
      NULL,
      1.301560,
      0,
      1.977682,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      1.941043,
      1,
      7,
      6,
      NULL,
      1.264393,
      0,
      10,
      NULL,
      2.812313,
      1,
      0.541179,
      NULL,
      1.724348,
      1,
      NULL,
      NULL,
      0.192880,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.277326,
      NULL,
      1,
      1.419486,
      1.239600,
      2,
      2.724351,
      0.946035,
      1,
      1,
      1,
      3,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.601449,
      0.381622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.949422,
      1,
      NULL,
      1.581501,
      1.216210,
      1,
      1.415752,
      1.187205,
      0.818029,
      0.388116,
      NULL,
      0,
      2,
      0,
      1,
      1.111881,
      NULL,
      1.514417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.458243,
      0.087363,
      1,
      1,
      NULL,
      0,
      1,
      1.858585,
      NULL,
      0,
      0,
      NULL,
      0,
      2.042055,
      2.398378,
      2.215096,
      2,
      0.544564,
      NULL,
      NULL,
      1.495179,
      4.462900,
      1,
      2.069543,
      1.291307,
      0.556278,
      0.937070,
      1,
      1.052450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727293,
      1,
      1,
      0,
      NULL,
      0,
      0.191216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.977253,
      0,
      0.505191,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.790213,
      NULL,
      NULL,
      NULL,
      1.865462,
      2.381774,
      0.597962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      1,
      3.495474,
      3.135188,
      0.470935,
      NULL,
      0.114147,
      0,
      0.860030,
      0,
      0,
      0.653664,
      NULL,
      1,
      1.656905,
      0,
      0.183645,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163931,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.404426,
      NULL,
      '',
      '',
      3,
      1,
      1.153139,
      0,
      3.223724,
      2,
      2.587113,
      2,
      0);
commit;
end;
/


