set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42032420',
      NULL,
      34,
      '1134402',
      12,
      1,
      1.200667,
      2,
      '243431',
      4,
      ' 7-14-1981',
      NULL,
      NULL,
      1,
      NULL,
      1.112403,
      2.989849,
      NULL,
      0,
      1,
      1.496713,
      0.584945,
      1.604048,
      2.806983,
      0,
      6,
      0,
      NULL,
      NULL,
      0.107736,
      0.438502,
      4.048099,
      3,
      1.655567,
      1,
      2.535587,
      1.184754,
      7,
      1,
      NULL,
      4,
      NULL,
      0.680405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.356394,
      1.056614,
      0.335446,
      1.152983,
      NULL,
      1,
      3.238722,
      3.726786,
      2,
      1,
      3,
      1,
      1,
      2,
      NULL,
      0.666241,
      NULL,
      0.853469,
      1.796608,
      2.308654,
      NULL,
      1,
      4.149078,
      1,
      2,
      1.497348,
      0,
      NULL,
      NULL,
      1.280169,
      NULL,
      NULL,
      NULL,
      1.617246,
      2,
      NULL,
      5,
      0,
      0.851594,
      1,
      0,
      0.889608,
      NULL,
      1,
      1,
      0.501173,
      1,
      0.250804,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      7,
      1,
      6,
      0.109698,
      5.504481,
      0.685204,
      4.094214,
      6,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.459195,
      8.378715,
      6.094091,
      NULL,
      6.472760,
      NULL,
      9,
      4,
      2,
      6.538433,
      2,
      0.528373,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.917987,
      2.421555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2.473783,
      0,
      0.859149,
      1.789394,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082329,
      2.585163,
      3.449881,
      3.565448,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0.533646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.041748,
      3.241606,
      NULL,
      3.254109,
      3,
      1,
      2.307912,
      1,
      1,
      0.374889,
      1,
      1,
      1.104706,
      NULL,
      0.615293,
      1,
      0.117037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '10234',
      '',
      '',
      0.489647,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      2.463156,
      1,
      1.970590,
      2,
      2.364186,
      NULL,
      NULL,
      1.453314,
      0.584180);
commit;
end;
/


