set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2422',
      '22430044',
      31.687759,
      NULL,
      '1020301',
      37,
      1,
      3.145107,
      2,
      '431140',
      NULL,
      NULL,
      NULL,
      48.781805,
      0.093469,
      NULL,
      0.824218,
      NULL,
      1,
      0,
      1,
      1.750691,
      0,
      1,
      NULL,
      NULL,
      2.554378,
      1,
      1.061109,
      0,
      0.528541,
      NULL,
      4,
      NULL,
      2,
      NULL,
      NULL,
      1.636082,
      7.911484,
      1,
      2.931276,
      3,
      0.534780,
      1.184391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.074743,
      1,
      0.754919,
      0,
      1.584012,
      0.954151,
      0,
      1.589352,
      0.987406,
      2,
      2.538877,
      1,
      0,
      NULL,
      0.451481,
      NULL,
      3,
      1,
      1.907698,
      1.002556,
      0.204924,
      0,
      NULL,
      0,
      1,
      0,
      0.392078,
      NULL,
      NULL,
      1.048453,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.890463,
      4.466505,
      0,
      NULL,
      1.282939,
      1,
      0.654304,
      0.885634,
      0.989461,
      1.214150,
      NULL,
      1,
      1,
      0.440145,
      0,
      1.799570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.019317,
      0.348612,
      5.196902,
      NULL,
      0.086980,
      0,
      3,
      2.415056,
      5,
      1.007093,
      2.974670,
      NULL,
      0,
      NULL,
      2.492481,
      7,
      4,
      NULL,
      4.555978,
      4,
      3.122973,
      NULL,
      0.241510,
      5,
      2,
      0.641239,
      0,
      4.852369,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0,
      0.117240,
      0.558776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.163619,
      NULL,
      1.086518,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.483978,
      0.406500,
      0.897047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.324791,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.925048,
      0.977898,
      1.124387,
      1,
      0,
      NULL,
      0,
      0.350049,
      0.070269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.489588,
      '11111',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      5,
      1.157487,
      3.155059,
      4.531173,
      2,
      3,
      NULL,
      3.029126,
      1);
commit;
end;
/


